/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SandSlabBlock
extends FallingBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.f_61397_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SandSlabBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        SlabType slabType = (SlabType)state.m_61143_(TYPE);
        switch (slabType) {
            case DOUBLE: {
                return Shapes.m_83144_();
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.m_8083_();
        BlockState blockState = ctx.m_43725_().m_8055_(blockPos);
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)blockState.m_61124_(TYPE, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluidState = ctx.m_43725_().m_6425_(blockPos);
        BlockState blockState2 = (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        Direction direction = ctx.m_43719_();
        return !(direction == Direction.DOWN || direction != Direction.UP && ctx.m_43720_().f_82480_ - (double)blockPos.m_123342_() > 0.5) ? blockState2 : (BlockState)blockState2.m_61124_(TYPE, (Comparable)SlabType.TOP);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        ItemStack itemStack = context.m_43722_();
        SlabType slabType = (SlabType)state.m_61143_(TYPE);
        if (slabType != SlabType.DOUBLE && itemStack.m_150930_(this.m_5456_())) {
            if (context.m_7058_()) {
                boolean bl = context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5;
                Direction direction = context.m_43719_();
                if (slabType == SlabType.BOTTOM) {
                    return direction == Direction.UP || bl && direction.m_122434_().m_122479_();
                }
                return direction == Direction.DOWN || !bl && direction.m_122434_().m_122479_();
            }
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE ? super.m_7361_(world, pos, state, fluidState) : false;
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE ? super.m_6044_(world, pos, state, fluid) : false;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

